
function EditStyle()
{
    var styleindex = moi.ui.propertiesPanel.styleIndex;
    var dialog = moi.ui.createDialog( 'EditStyleDialog.htm?index=' + styleindex, '', moiWindow );
    dialog.window.doModal();
}

function HideElement( element )
{
    if ( element.style.display != 'none' )
        element.style.display = 'none';
}

function ShowElement( element )
{
    if ( element.style.display != '' )
        element.style.display = '';
}

function PropPanelFormatSize( number, units )
{
	// Format a number value for display in the properties panel Size: control.
	
	var precision = -1; // -1 means use user-set precision value.
	
	if ( units == moi.geometryDatabase.units && moi.geometryDatabase.isFeetAndInchesDisplay )
	{
		// Some special handling for feet and inches style output.
		
		var is_inches = (units == 'Inches');
		var one_inch = (is_inches ? 1.0 : 1.0/12.0);
		
		if ( Math.abs(number) < one_inch )
		{
			// Less than an inch in size, use 1/64 fractional accuracy to try to reduce rounding to 0.
			precision = Math.max( 6, moi.ui.fractionalDisplayPrecision );
		}
		
		return moi.ui.formatCoordinate( number, precision );
	}
	else	
	{
		// Decimal number style output.
		
		if ( units != moi.geometryDatabase.units )
			number *= moi.geometryDatabase.getUnitConversionScaleFactor( moi.geometryDatabase.units, units );
	
		if ( Math.abs(number) < 0.01 )
		{
			// If smaller than 0.01 use 4 decimal places (or user value if higher).
			precision = Math.max( 4, moi.ui.numDecimalPlaces );
		}
		
		return moi.ui.formatNumber( number, precision );
	}
}

function GetPropPanelSizeText( units )
{
	// Returns text of the prop panel size line, without any units designator at the end.

	var pp = moi.ui.propertiesPanel;
	
	var text = '';

	if ( pp.hasRadius || pp.hasLength )
	{
		// If there is a radius or length available, show those instead of bounding box info.
		
		if ( pp.hasRadius )
		{
			if ( pp.useDiameter )
				text += moi.ui.getText('Properties panel diameter label');
			else							
				text += moi.ui.getText('Properties panel radius label');
									
			text += (pp.hasLength ? ' ' : '  ') + PropPanelFormatSize( pp.useDiameter ? pp.radius * 2.0 : pp.radius, units );
		}
			
		if ( pp.hasLength )
		{
			if ( pp.hasRadius )
				text += '  ' + moi.ui.getText('Properties panel height label') + ' ';
			else
				text += moi.ui.getText('Properties panel length label') + '  ';
				
			text += PropPanelFormatSize( pp.length, units );
		}
	}
	else
	{
		// Otherwise display bounding box size.
		
		var box = pp.quickBoundingBox;
		
		// Don't show anything if all extents are 0 (single point selected).
		
		if ( box != null && !(box.xLength == 0.0 && box.yLength == 0.0 && box.zLength == 0.0) )
		{
			// Show the size control and gather the size as text in a
			// form like: 55.2 x 55.1 mm
			
			if ( moi.ui.numDecimalPlaces >= 4 )
				text = ''; // With 4 or more decimal places there isn't enough room to put "Size:" in the front.
			else
				text = moi.ui.getText( 'Properties panel size label' ) + '  ';
		
			text += PropPanelFormatSize( box.xLength, units ) + ' x ' + PropPanelFormatSize( box.yLength, units );

			// Omit z if it is zero.
			if ( box.zLength != 0.0 )
				text += ' x ' + PropPanelFormatSize( box.zLength, units );
		}
	}

	return text;
}

function PropObjectSizeUnitsMouseOver()
{
	// Unhighlight the parent when moused over the units control.
	PropSizeContainer.style.backgroundColor = 'transparent';
}

function PropObjectSizeUnitsMouseOut()
{
	// Reset the parent background when leaving the units control.
	PropSizeContainer.style.backgroundColor = '';
}

function PropObjectSizeUnitsMouseDown()
{
	// Clicked on the units label, show the quick conversion menu.
	event.cancelBubble = true;
	moi.ui.showMenu( 'PropPanelUnitsMenu.htm', PropSizeContainer, 0, 0 );
}

function UpdatePropPanelSize()
{
    // A script can set the g_PropPanelUnits value to make the properties panel display in alternate units.
    var units = window.g_PropPanelUnits ? window.g_PropPanelUnits : moi.geometryDatabase.units;

    var size_text = GetPropPanelSizeText( units );

    if ( size_text == '' )
    {
        HideElement( PropSizeContainer );
    }
    else
    {
        // Add clickable units label
        var unitslabel = moi.geometryDatabase.getUnitsShortLabelFor( units );
        if ( unitslabel != '' )
            size_text += ' <span id="PropObjectSizeUnits" class="label_button" onmouseover="PropObjectSizeUnitsMouseOver();" onmouseout="PropObjectSizeUnitsMouseOut();" onmousedown="PropObjectSizeUnitsMouseDown();">' + unitslabel + '</span>';

        if ( PropObjectSize.lastInnerHTML != size_text )
        {
            PropObjectSize.lastInnerHTML = size_text;
            PropObjectSize.innerHTML = size_text;
        }

        ShowElement( PropSizeContainer );
    }
}
